//
#define BOX_board_bottom 21
#define BOX_board_right 11

#define array_size (((BOX_board_bottom+8)/8) * (BOX_board_right + 1))

#define default_fg_color 1
#define default_bg_color 0
#define GLCD_GoTo(x,y)   ks0108_gotoxy(x,y)
#define GLCD_WriteData(dat) ks0108_Write(dat)

#define white 0

unsigned char BOX_piece[4];
char __PPPTT=0;
flash char  BOX_reference[7][4][4] = {
        //T
        {
                {
                        0b00000010,
                        0b00000011,
                        0b00000010,
                        0b00000000
                },

                {
                        0b00000000,
                        0b00000111,
                        0b00000010,
                        0b00000000
                },

                {
                        0b00000001,
                        0b00000011,
                        0b00000001,
                        0b00000000
                },

                {
                        0b00000010,
                        0b00000111,
                        0b00000000,
                        0b00000000
                }
        },

        // S
        {
                {
                        0b00000010,
                        0b00000011,
                        0b00000001,
                        0b00000000
                },

                {
                        0b00000011,
                        0b00000110,
                        0b00000000,
                        0b00000000
                },

                {
                        0b00000010,
                        0b00000011,
                        0b00000001,
                        0b00000000
                },

                {
                        0b00000011,
                        0b00000110,
                        0b00000000,
                        0b00000000
                }
        },

        // Z
        {
                {
                        0b00000001,
                        0b00000011,
                        0b00000010,
                        0b00000000
                },

                {
                        0b00000110,
                        0b00000011,
                        0b00000000,
                        0b00000000
                },

                {
                        0b00000001,
                        0b00000011,
                        0b00000010,
                        0b00000000
                },

                {
                        0b00000110,
                        0b00000011,
                        0b00000000,
                        0b00000000
                }
        },

        // L
        {
                {
                        0b00000011,
                        0b00000001,
                        0b00000001,
                        0b00000000
                },

                {
                        0b00000000,
                        0b00000001,
                        0b00000111,
                        0b00000000
                },

                {
                        0b00000010,
                        0b00000010,
                        0b00000011,
                        0b00000000
                },

                {
                        0b00000000,
                        0b00000111,
                        0b00000100,
                        0b00000000
                }
        },

        // J
        {
                {
                        0b00000001,
                        0b00000001,
                        0b00000011,
                        0b00000000
                },

                {
                        0b00000000,
                        0b00000100,
                        0b00000111,
                        0b00000000
                },

                {
                        0b00000011,
                        0b00000010,
                        0b00000010,
                        0b00000000
                },

                {
                        0b00000000,
                        0b00000111,
                        0b00000001,
                        0b00000000
                }
        },

        // Box
        {
                {
                        0b00000011,
                        0b00000011,
                        0b00000000,
                        0b00000000
                },

                {
                        0b00000011,
                        0b00000011,
                        0b00000000,
                        0b00000000
                },

                {
                        0b00000011,
                        0b00000011,
                        0b00000000,
                        0b00000000
                },

                {
                        0b00000011,
                        0b00000011,
                        0b00000000,
                        0b00000000
                }
        },

        // Line
        {
                {
                        0b00000010,
                        0b00000010,
                        0b00000010,
                        0b00000010
                },

                {
                        0b00000000,
                        0b00001111,
                        0b00000000,
                        0b00000000
                },

                {
                        0b00000010,
                        0b00000010,
                        0b00000010,
                        0b00000010
                },

                {
                        0b00000000,
                        0b00001111,
                        0b00000000,
                        0b00000000
                }
        }
};
flash char  message1[] = { "**Tetris**    Game!" };
flash char  message2[] = { "Pres Enter"} ;
flash char  message3[] = { " To start" };
flash char  message4[] = { "Game Over" };
flash char  message5[] = { "Lines:" };

//Variables
unsigned char BOX_location[array_size];
unsigned char x_loc, y_loc;     //Bottom left index of each piece
unsigned char cur_piece = 0;	//Index for BOX_reference
unsigned char rotate = 0;		//Index for piece rotation
unsigned char score;		//Track the number of rows completed

/**********************************************
 * Functions that handle bits in BOX_location[]
 * BOX_loc_return_bit
 * BOX_loc_set_bit
 * BOX_loc_clear_bit
 ************************************************/

unsigned char BOX_loc_return_bit(unsigned char X, unsigned char Y)
{
  //Calculate array index and shift amount
  unsigned char array_index_offset = ((Y)/8)*(BOX_board_right+1);
  unsigned char shift_index ;		//How much to shift for our bit mask
  
  shift_index = (Y)%8;		//How much to shift for our bit mask
  if (BOX_location[X+array_index_offset] & 1<<shift_index) return 1;
  else return 0;
}

void BOX_draw(unsigned char X, unsigned char Y, unsigned char color)
{
	  unsigned char temp_data;
      unsigned char i;
	  if (X%2)
	  {
		  if (BOX_loc_return_bit(X-1,Y)) temp_data = 0xFF;
		  else temp_data = 240;//0xF0;
	  }
	  else
	  {
		  if (BOX_loc_return_bit(X+1,Y)) temp_data = 0xFF;
		  else temp_data = 0x0F;
	  }
	  Y = (BOX_board_bottom*4)-(Y*4);
	  ks0108_gotoxy(Y+8, (X/2)+1);
	  for (i=0; i<4; i++)
	  {
		  ks0108_Write(temp_data);
	  }
}

void BOX_erase(unsigned char X, unsigned char Y)
{
	  unsigned char temp_data;
      unsigned char i;
      
	  if (X%2)
	  {
		  if (BOX_loc_return_bit(X-1,Y)) temp_data = 0x0F;
		  else temp_data = 0x00;
	  }
	  else
	  {
		  if (BOX_loc_return_bit(X+1,Y)) temp_data = 240;//0xF0;
		  else temp_data = 0x00;
	  }
	  Y = (BOX_board_bottom*4)-(Y*4);
	  ks0108_gotoxy(Y+8, (X/2)+1);
	  for (i=0; i<4; i++)
	  {
		  ks0108_Write(temp_data);
	  }
}


void BOX_update_score(void)  //TODO: horrible hack --- clean this up!
{
	//Update the score on the display
	unsigned char score_array[14];
	unsigned char tens = score/10;
        unsigned char ones = score%10;
	unsigned char char_column_info;
	unsigned char i,j;
        tens += 16; //Adjustment for font5x8.h
	ones += 16; //Adjustment for font5x8.h

	//Preload the background data to make this look pretty
	for (i=0; i<4; i++)
	{
	        score_array[(i*2)+7] = 0b10110000;
	    score_array[(i*2)+8] = 0b01010000;
	}



	for (i=0; i<5; i++)
	{
		char_column_info = *(font + (5 * tens) + i); //Read column in from font5x8.h
		for (j=0; j<7; j++)
		{
			if (char_column_info & (1<<(6-j))) score_array[j] |= 1<<i;
			else score_array[j] &= ~(1<<i);
		}

	}
	for (j=0; j<7; j++) score_array[j] &= ~(1<<5); //Space between number
	for (i=6; i<8; i++)
	{
		char_column_info = *(font + (5 * ones) + (i-6)); //Read column in from font5x8.h
		for (j=0; j<7; j++)
		{
			if (char_column_info & (1<<(6-j))) score_array[j] |= 1<<i;
			else score_array[j] &= ~(1<<i);
		}
	}
	for (i=0; i<3; i++)
	{
		char_column_info = *(font + (5 * ones) + (i+2)); //Read column in from font5x8.h
		for (j=0; j<7; j++)
		{
			if (char_column_info & (1<<(6-j))) score_array[j+7] |= 1<<i;
			else score_array[j+7] &= ~(1<<i);
		}
	}

	GLCD_GoTo(110,6);
	for (i=0; i<7; i++) GLCD_WriteData(score_array[i]);
	GLCD_GoTo(110,7);
	for (i=0; i<7; i++) GLCD_WriteData(score_array[i+7]);
}

void BOX_rewrite_display(unsigned char fgcolor, unsigned char bgcolor)	//Rewrites entire playing area
{
  unsigned char cols;
  unsigned char rows;
  
  for (cols=0; cols<=BOX_board_right; cols++)
  {
	  for (rows=0; rows<=BOX_board_bottom; rows++)
	  {
		  if(BOX_loc_return_bit(cols,rows)) BOX_draw(cols,rows,fgcolor);
		  else BOX_erase(cols,rows);
	  }
  }
}

void BOX_load_reference(unsigned char piece, unsigned char rotation)
{
	  BOX_piece[0] = BOX_reference[piece][rotation][0];
	  BOX_piece[1] = BOX_reference[piece][rotation][1];
	  BOX_piece[2] = BOX_reference[piece][rotation][2];
	  BOX_piece[3] = BOX_reference[piece][rotation][3];
}



void BOX_loc_set_bit(unsigned char X, unsigned char Y)
{
  //Calculate array index and shift amount
  unsigned char array_index_offset = ((Y)/8)*(BOX_board_right+1);
  unsigned char shift_index = (Y)%8;		//How much to shift for our bit mask

  BOX_location[X+array_index_offset] |= 1<<shift_index;
}

void BOX_loc_clear_bit(unsigned char X, unsigned char Y)
{
  //Calculate array index and shift amount
  unsigned char array_index_offset = ((Y)/8)*(BOX_board_right+1);
  unsigned char shift_index = (Y)%8;		//How much to shift for our bit mask

  BOX_location[X+array_index_offset] &= ~(1<<shift_index);
}

void BOX_clear_loc(void)
{
  //Step through 4 columns
  unsigned char temp_col; 
  unsigned char temp_row;
  
  for ( temp_col=0; temp_col<4; temp_col++)
  {
    //Only if x_loc is not out of bounds
    if ((unsigned char)(x_loc+temp_col) <= BOX_board_right)
    {
      //Step through 4 rows
      for (temp_row=0; temp_row<4; temp_row++)
      {
		//Only if y_loc is not out of bounds
		if (y_loc-temp_row <= BOX_board_bottom)
		{
		  if (BOX_piece[temp_col] & 1<<(temp_row))	//Checks nibbles in Box_piece array
		  {
			BOX_loc_clear_bit((unsigned char)(x_loc+temp_col),y_loc-temp_row);
		  }
		}
      }
    }
  }
}

void BOX_store_loc(void)
{
  unsigned char temp_col; 
  unsigned char temp_row;
  //Step through 4 columns
  for (temp_col=0; temp_col<4; temp_col++)
  {
    //Only if x_loc is not out of bounds
    if ((unsigned char)(x_loc+temp_col) <= BOX_board_right)
    {
      //Step through 4 rows
      for (temp_row=0; temp_row<4; temp_row++)
      {
		//Only if y_loc is not out of bounds
		if (y_loc-temp_row <= BOX_board_bottom)
		{
		  if (BOX_piece[temp_col] & 1<<(temp_row))	//Checks nibbles in Box_piece array
		  {
			BOX_loc_set_bit((unsigned char)(x_loc+temp_col),y_loc-temp_row);
		  }
		}
      }
    }
  }
}

unsigned char BOX_check(signed char X_offset, signed char Y_offset)
{
	unsigned char temp_area[4] = { 0x00, 0x00, 0x00, 0x00 };
	unsigned char i;
    unsigned char j;
	//Build compare mask in temp_area[]

		//Clear the current piece from BOX_location[] so we don't have a false overlap
			//Do this only if X_offset and Y_offset aren't both 0 (used for BOX_spawn)
		if (X_offset || Y_offset) BOX_clear_loc();
		//mask will be 4 sets of nibbles (2 bytes)
		for (i=0; i<4; i++)
		{
			//if out of bounds on the x axis
			if ((unsigned char)(x_loc+X_offset+i) > BOX_board_right) temp_area[i] = 0x0F;
			else
			{
				for (j=0; j<4; j++)
				{
					//if we're out of bounds on the y axis
					if (((unsigned char)(y_loc+Y_offset-j) > BOX_board_bottom) ||
					   (BOX_loc_return_bit((unsigned char)(x_loc+X_offset+i),(unsigned char)(y_loc+Y_offset-j))))
					{
						temp_area[i] |= 1<<j;
					}
				}
			}
		}
		if (X_offset || Y_offset) BOX_store_loc(); //Restore the location we cleared earlier

	if ((temp_area[0] & BOX_piece[0]) | (temp_area[1] & BOX_piece[1]) | (temp_area[2] & BOX_piece[2]) | (temp_area[3] & BOX_piece[3]))
	{
		//Conflict has been found
		return 1;
	}
	else return 0;
}

void BOX_end_game(void)
{
  BOX_rewrite_display(white,black);

  GLCD_string_sideways(1,54, message4, (sizeof(message4) / sizeof(message4[0])));

      while(1){ 
       if (get_key_press(1<<BTN_EN)){
       paly_sound_key(key_sound);
       break;
       }
       if (get_key_press(1<<BTN_MD))
            if(sound_is_play)
                stop_sound();
           else
                play_sound(tetris_sound);
       } 
       
    __PPPTT=0;  
  //while(1) { }
}

void BOX_write_piece(void)  //Writes piece to display
{
    unsigned char i,j;
  for (i=0; i<4; i++)  //Step through each of 4 columns
  {
    for (j=0; j<4; j++) //Step through each of 4 rows
    {
    //prevent invalid indices from being written
      if ((y_loc-j) >= 0)
      {
		if (BOX_piece[i] & 1<<j)
		{
		  //TODO: change this for different colored playing pieces
		  BOX_draw(x_loc+i, y_loc-j, default_fg_color);
		}
      }
    }
  }
}

void BOX_spawn(void)
{
  x_loc = 4;
  y_loc = 1;
  cur_piece = rnd(0,7);//random_piece;
  rotate = 0;

  BOX_load_reference(cur_piece, rotate);  //load from reference



  //Check to see if we've filled the screen
  if (BOX_check(0,0))
  {
	  BOX_end_game();
  }


  BOX_store_loc(); //Store new location
  BOX_write_piece(); //draw piece

}

void BOX_start_game(void)
{

  //Populate BOX_location[] with 0
  unsigned char i;
  unsigned char j;
  
  for (i=0; i<array_size; i++) { BOX_location[i] = 0x00; }

  //Draw frame around playing area

  //Page 0
  GLCD_GoTo(0,0);
  for (i=0; i<3; i++) 		//0-5
  {
	  GLCD_WriteData(0xAA);
	  GLCD_WriteData(0x55);
  }
  GLCD_WriteData(0xAA); 	//6
  for (i=0; i<45; i++) 		//7-97
  {
	  GLCD_WriteData(0xD5);
	  GLCD_WriteData(0xAA);
  }
  for (i=0; i<5; i++)		//98-106
  {
	  GLCD_WriteData(0x55);
	  GLCD_WriteData(0xAA);
  }
  GLCD_WriteData(0x55);		//107
  for (i=0; i<5; i++)		//108-118
  {
	  GLCD_WriteData(0xAA);
	  GLCD_WriteData(0xD5);
  }
  for (i=0; i<5; i++)		//119-127
  {
	  GLCD_WriteData(0xAA);
	  GLCD_WriteData(0x55);
  }

  //Page 1-6
  for (j=1; j<7; j++)
  {
	  GLCD_GoTo(0,j);
	  for (i=0; i<3; i++)
	  {
		  GLCD_WriteData(0xAA);
		  GLCD_WriteData(0x55);
	  }
	  GLCD_WriteData(0xAA);
	  GLCD_WriteData(0xFF);
	  GLCD_GoTo(96,j);
	  GLCD_WriteData(0xFF);
	  for (i=0; i<5; i++)
	  {
		  GLCD_WriteData(0x55);
		  GLCD_WriteData(0xAA);
	  }
	  GLCD_WriteData(0x55);
	  GLCD_WriteData(0xFF);
	  GLCD_GoTo(118,j);
	  GLCD_WriteData(0xFF);
	  for (i=0; i<7; i++)		//119-127
	  {
		  GLCD_WriteData(0x55);
		  GLCD_WriteData(0xAA);
	  }
  }

  //Page 7
  GLCD_GoTo(0,7);
  for (i=0; i<3; i++)			//0-5
  {
	  GLCD_WriteData(0xAA);
	  GLCD_WriteData(0x55);
  }
  GLCD_WriteData(0xAA);			//6
  for (i=0; i<45; i++)			//7-96
  {
	  GLCD_WriteData(0x55);
	  GLCD_WriteData(0xAB);
  }
  for (i=0; i<5; i++)			//97-108
  {
	  GLCD_WriteData(0x55);
	  GLCD_WriteData(0xAA);
  }
  GLCD_WriteData(0x55);
  GLCD_WriteData(0xBF);			//109
  for (i=0; i<4; i++)			//110-117
  {
	  GLCD_WriteData(0x50);
	  GLCD_WriteData(0xB0);
  }
  GLCD_WriteData(0x50);			//118
  GLCD_WriteData(0xBF);			//119
  for (i=0; i<4; i++)			//109-126
  {
	  GLCD_WriteData(0x55);
	  GLCD_WriteData(0xAA);
  }
  GLCD_WriteData(0x55);			//127


  score = 0; //Reset score
  GLCD_string_sideways(1,110, message5, (sizeof(message5) / sizeof(message5[0])));
  BOX_update_score();

  BOX_rewrite_display(black, white);
  BOX_spawn();
}




void BOX_clear_piece(void)  //Clears piece from display
{
unsigned char i,j;
  for (i=0; i<4; i++)  //Step through each of 4 columns
  {
    for (j=0; j<4; j++) //Step through each of 4 rows
    {
    //prevent invalid indices from being written
      if ((y_loc-j) >= 0)
      {
  		if (BOX_piece[i] & 1<<j)
  		{
  		  //TODO: change this for different colored playing pieces
  		  BOX_erase(x_loc+i, y_loc-j);
  		}
      }
    }
  }
}


void BOX_rotate(unsigned char direction)
{
  //TODO: Allow for adjustments if rotation is prevented due to proximity
   unsigned char new_rotate = rotate;
   
  BOX_clear_loc(); //Clear current location so we don't have false compares

  //Load in the candidate rotation
  
  if (++new_rotate > 3) new_rotate = 0;
  BOX_load_reference(cur_piece,new_rotate);

  //Check for overlaps
  if (BOX_check(0, 0))
  {
	  //Overlap will be caused, restore piece settings and return
	  BOX_load_reference(cur_piece, rotate);
	  BOX_store_loc();
	  return;
  }
  //No overlap found, allow new rotation
  else
  {
	  //Load the current rotation back in and clear the piece from display
	  BOX_load_reference(cur_piece, rotate);
	  BOX_clear_piece();

	  //Load new rotation, display, and save its location
	  rotate = new_rotate;
	  BOX_load_reference(cur_piece, rotate);

	  BOX_store_loc();
	  BOX_write_piece();
  }
}






void BOX_line_check(void)
{
  //TODO: Tweak this to enable scoring

  //Check every line on the playing area for complete rows and record them in an array
  unsigned char complete_lines[4];	//There will never be more than 4 complete rows
  unsigned char temp_index = 0;		//Index for complete_lines[]
  unsigned char board_rows;
  unsigned char board_cols=0;
  unsigned char read_from_row;
  unsigned char write_to_row;
  unsigned char rows_left_to_read,i;
  unsigned char col;
  
  for (board_rows=0; board_rows<=BOX_board_bottom; board_rows++)
  {
    board_cols=0;
    while ((board_cols<=BOX_board_right) && (BOX_loc_return_bit(board_cols,board_rows)))
    {
    	//Complete row found, record in complete_lines[]
		if (board_cols == BOX_board_right) complete_lines[temp_index++] = board_rows;
		++board_cols;
    }
  }
  if (temp_index == 0) return;  //No complete lines found, return


  //If there are complete rows
    //TODO: Disable interrupts to pause game flow
    //TODO: Add an arbitrary delay, perhaps make complete lines flash?

  score += temp_index; //Add the completed rows to our score
  paly_sound_key(tetris_one);
  if(overflow_t0>=30);
  overflow_t0-=5;
  
  --temp_index;	//This was incremented one too many times earlier, get it back to the proper index.

  //Rewrite BOX_location[] data without completed lines
  read_from_row = BOX_board_bottom;
  write_to_row = BOX_board_bottom;

  //When we have read from all rows, this will be set to 0 and
  //remaining bits cleared from BOX_location[]
  rows_left_to_read = 1;

  //Use variable i to iterate through every row of the board
  i=0;
  while (i <= BOX_board_bottom)
  {
	  //If the current row is a complete line
	  if (read_from_row == complete_lines[temp_index])
	  {
		  //Decrement indexes
		  if (read_from_row == 0)
		  {
			  rows_left_to_read = 0;

			  //Change complete_lines[0] so we don't do this again
			  complete_lines[0] = BOX_board_bottom;
		  }
		  else
		  {
			  --read_from_row;
			  if (temp_index) --temp_index;
		  }
	  }

	  else
	  {
		  //Write data to all columns of current row
		  for (col=0; col<=BOX_board_right; col++)
		  {
			  //If there are rows left to read from, do so.
			  if (rows_left_to_read)
			  {
				  if (BOX_loc_return_bit(col,read_from_row)) BOX_loc_set_bit(col, write_to_row);
				  else BOX_loc_clear_bit(col, write_to_row);
			  }
			  //There are no rows left to read from, fill with 0
			  else
			  {
				  BOX_loc_clear_bit(col, write_to_row);
			  }
		  }

		  //A row has now been read from, decrement the counter
		  --read_from_row;

		  //A row has now been written to, increment the counter, decrement the tracker
		  ++i;
		  --write_to_row;
	  }
  }

  BOX_rewrite_display(black, white);
  BOX_update_score();
}


void BOX_up(void)
{
  BOX_clear_loc();
  BOX_clear_piece();

  if (++cur_piece > 6) cur_piece = 0;
  x_loc = 4;
  y_loc = 0;

  BOX_spawn();
}

void BOX_dn(void)
{
  if (BOX_check(0, 1))
  {
    //Set piece here and spawn a new one
    BOX_rewrite_display(black, default_bg_color);
    BOX_line_check();
    BOX_spawn();
    return;
  }

  BOX_clear_loc();
  BOX_clear_piece();
  ++y_loc;

  BOX_store_loc();
  BOX_write_piece();
}

void BOX_lt(void)
{
  if (BOX_check(-1, 0)) return; //Do nothing if moving causes an overlap
  BOX_clear_loc();
  BOX_clear_piece();
  x_loc--;

  BOX_store_loc();
  BOX_write_piece();
}

void BOX_rt(void)
{
  if (BOX_check(1, 0)) return; //Do nothing if moving causes an overlap
  BOX_clear_loc();
  BOX_clear_piece();
  ++x_loc;

  BOX_store_loc();
  BOX_write_piece();
}

void Run_tetris(void){

overflow_t0=100; // For 1 secend
ks0108_ClearScreen();

  GLCD_GoTo(40,4);
  GLCD_string_sideways(0,88,message1, (sizeof(message1) / sizeof(message1[0])));
  GLCD_string_sideways(0,52,message2, (sizeof(message2) / sizeof(message2[0])));
  GLCD_string_sideways(0,44,message3, (sizeof(message3) / sizeof(message3[0])));
light_on(150);
play_sound(tetris_sound);
while(get_key_press(1<<BTN_EN) == 0){
      if (get_key_press(1<<BTN_MD))
            if(sound_is_play)
                stop_sound();
           else
                play_sound(tetris_sound);   
      
      if (get_key_press(1<<BTN_ES)){
        light_off(150);
        return;
        }
}
light_off(150);
BOX_start_game();
light_on(150);
__PPPTT=1;
while (__PPPTT)
      {
          if (get_key_press(1<<BTN_MD))
            if(sound_is_play)
                stop_sound();
           else
                play_sound(tetris_sound);
                
    if (get_key_press(1<<BTN_UP)!=0)
    {
      paly_sound_key(key_sound);
      BOX_rotate(1);
    }

    if (get_key_press(1<<BTN_DN))
    { 
    paly_sound_key(key_sound);
      BOX_dn();
    }

    if (get_key_press(1<<BTN_LT)) {
    paly_sound_key(key_sound);
      BOX_lt();
    }

    if (get_key_press(1<<BTN_RT))
    {
    paly_sound_key(key_sound);
      BOX_rt();
    }

    if (get_key_press(1<<BTN_EN))
    {
    paly_sound_key(key_sound);
      BOX_rotate(1);
    }
    
    if (drop_timer_flag)
    {
      drop_timer_flag = 0;
      BOX_dn();
    }
    
    if (get_key_press(1<<BTN_ES)){
       paly_sound_key(key_sound);
       light_off(150);
        break;
        }
        
      };


}
